<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/


/**
* description
*
* @library	
* @author	
* @since	
*/
class CRedirectsBackend extends CPlugin{	
	

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("redirects");
	} 

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RecordStat($rule_id) {
		$this->db->QueryInsert(
			$this->tables["plugin:redirects_stats"] , 
			array(
				"stat_redirect"	=> $rule_id , 
				"stat_date"		=> time(),
				"stat_from"		=> $_SERVER["HTTP_REFERER"],
				"stat_ip"		=> $_SERVER["REMOTE_ADDR"],
			)
		);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetDomain($dom) {
		$domain = $this->db->QFetchArray("
			SELECT * FROM 
				{$this->tables['plugin:redirects_domains']}
			WHERE
				domain_name LIKE '%s'
		" , array($dom));

		if (!is_array($domain)) {

			$domain = array(
				"domain_name"	=> strtolower($dom),
				"domain_clicks"	=> 0,
			);

			$domain["domain_id"] = $this->db->QueryInsert(
				$this->tables["plugin:redirects_domains"],
				$domain
			);
		}
		
		return $domain;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetMainDomain() {
		$domain = $this->db->QFetchArray("
			SELECT * FROM 
				{$this->tables['plugin:redirects_domains']}
			WHERE
				domain_main=1
		");

		return $domain;
	}
			
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CheckSSL($module = null) {
		$this->__init();

		if (defined("CLI") && CLI) {
			return true;
		}

		if (defined("STP_GLOBAL_PROTOCOL")  && (STP_GLOBAL_PROTOCOL == "http") && !$_SERVER["HTTPS"]) {
			} elseif (defined("STP_GLOBAL_PROTOCOL")  && (STP_GLOBAL_PROTOCOL == "https") && $_SERVER["HTTPS"]) {
				} elseif (defined("STP_GLOBAL_PROTOCOL")  && (STP_GLOBAL_PROTOCOL == "https") && !$_SERVER["HTTPS"]) {
						$changed = true;
						$protocol = "https://";
					} elseif (defined("STP_GLOBAL_PROTOCOL")  && (STP_GLOBAL_PROTOCOL == "http") && $_SERVER["HTTPS"]) {
							$changed = true;
							$protocol = "http://";
						} elseif($this->tpl_module["settings"]["set_site_protocol"] && !$_SERVER["HTTPS"])  {
								$changed = true;
								$protocol = "https://";
							} elseif (!$this->tpl_module["settings"]["set_site_protocol"] && $_SERVER["HTTPS"]) {
									$changed = true;
									$protocol = "http://";
								}

		if ($changed) {

			$domain = $_SERVER["HTTP_HOST"];
			$link = $_SERVER["REQUEST_URI"];

			header ( "Location: {$protocol}{$domain}{$link} ", true, 301 );
			exit();
		}

	}

		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetAllDomains() {

		if ($this->db->TableExists($this->tables["plugin:redirects_domains"])) {
			$domains = $this->db->Linear($this->db->QFetchRowArray("SELECT domain_name FROM {$this->tables['plugin:redirects_domains']}"));
		}
		
		return $domains;
	}
	
}

